using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Collections.Generic;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;

public partial class _Default : System.Web.UI.Page 
{
    public FTPHelper.FTPConnection FTP
    {
        set
        {
            ViewState["FTP"] = value;
        }
        get
        {
            return ViewState["FTP"] == null ? null : (FTPHelper.FTPConnection)ViewState["FTP"];
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {

    }
    protected void btnConnect_Click(object sender, EventArgs e)
    {
        ConnectToFtp();
    }

    public void ConnectToFtp()
    {
        try
        {
           FTP = new FTPHelper.FTPConnection(txtFTPUrl.Text.ToLower().Replace("ftp://",""), txtUser.Text, txtPassword.Text);
            Dictionary<string, string> Files = FTP.GetFileList(FTP._url);
            //string[] files = 
            lblWelcome.Text = "<strong> Welcome </strong> " + txtUser.Text;
            tbLogin.Visible = false;
            foreach (string ky in Files.Keys)
            {
                TreeNode trParent = new TreeNode();
                trParent.Text = (string)ky;
                trParent.Value = Files[ky];

                trVFiles.Nodes.Add(trParent);
            }
        }
        catch(Exception ex)
        {
            tbLogin.Visible = false;
            lblWelcome.Text = ex.Message;
            lblWelcome.ForeColor = System.Drawing.Color.Red;
        }
    }

    // capturing SelectedNodeChanged even to get the directory and files in selected directory
    protected void trVFiles_SelectedNodeChanged(object sender, EventArgs e)
    {
        Dictionary<string, string> _filesInFolder = FTP.GetFileList(trVFiles.SelectedValue);
        Dictionary<string, string> _onlyfiles = new Dictionary<string, string>();

        foreach (string key in _filesInFolder.Keys)
        {
            // checking if file is directory 
            if (key.IndexOf('.') == -1)
            {
                TreeNode trParent = new TreeNode();
                trParent.Text = (string)key;
                trParent.Value = _filesInFolder[key];
                trVFiles.SelectedNode.ChildNodes.Add(trParent); // appending directory to selected parent directory
            }
            else
            {
                _onlyfiles.Add(key, _filesInFolder[key]); // seperate the files 
            }
        }
        trVFiles.SelectedNode.Expand(); //expand the selected node
        BindGrid(_onlyfiles); // bind the grid with files separated
    }


    protected void BindGrid(Dictionary<string,string> _files)
    {
        DataTable dt = new DataTable();
        dt.Columns.Add("FileName");
        dt.Columns.Add("FolderUrl");

        if(_files!=null)
        foreach (string key in _files.Keys)
        {
            DataRow dr = dt.NewRow();
            dr[0] = key;
            dr[1] = _files[key];
            dt.Rows.Add(dr);
        }

        grdDetailView.DataSource = dt;
        grdDetailView.DataBind();
    }

    //So, Finally get RowCommand event to download the desired file
    protected void grdDetailView_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        byte[] _downFile = FTP.DownloadFileFromFtp(e.CommandArgument.ToString());
        string _fname =e.CommandArgument.ToString();
        Response.ContentType = "application/"+_fname.Split('.')[1];
        Response.AddHeader("Content-disposition", "attachment; filename=" + _fname);
        Response.OutputStream.Write(_downFile, 0, _downFile.Length);
        Response.End();
    }
    protected void btnLogout_Click(object sender, EventArgs e)
    {
        FTP = null;
        tbLogin.Visible = true;
        lblWelcome.Text = "";
        trVFiles.Nodes.Clear();
        BindGrid(null);
    }
}
